# ai-research

## Structure

```
.
├── common : 실험에 필요한 code base 모음
    ├── utils.py
    ├── losses.py
    ├── metrics.py
    ├── multi_processing.py
    ├── ...
    # 실험 base codes
    ├── dataset.py
    ├── models.py
    ├── trainer.py
    ├── run.py
    ├── config.yaml
├── exp : base code를 상속 및 복사 붙여넣기 후, 추가로 구현하여 실험
    ├── project 이름
        ├── dataset.py
        ├── trainer.py
        ├── models.py
        ├── run.py
        ├── config.yaml
    ├── ...
├── external : 외부 모델, library를 정리
    ├── model 이름
    ├── ...
├── preprocess : dataset 별로 전처리 코드 정리
    ├── dataset 이름
    ├── ...
├── examples : 구현에 활용되는 예시 파일 모음
    ├── cxr_image.jpg
    ...
├── scripts : 실행을 위한 bash script 파일 모음
    ├── restore_snapshot.sh
    ...
```
